
from openai import OpenAI
from dotenv import load_dotenv
import base64
import cv2
load_dotenv()

client = OpenAI()

# Otwarcie pliku wideo lub odczytanie wideo z adresu URL
video = cv2.VideoCapture("pliki/video.mp4")

# Wyodrębnianie klatek wideo
base64Frames = []
i=0
while video.isOpened():
    success, frame = video.read()
    i+=1
    if not success or i>5:
        break
    _, buffer = cv2.imencode(".jpg", frame)
    base64Frames.append(base64.b64encode(buffer).decode("utf-8"))

video.release()

# Utworzenie obiektu i wysłanie go do OpenAI. Tutaj wysyłanych jest 10 pierwszych klatek w postaci listy ciągów znaków formacie base64
images = [{"image": frame, "resize":768} for frame in base64Frames[2::3]]

# Wywołanie punktu końcowego czatu openai z podaniem modelu GPT-4 vision 
response = client.chat.completions.create(
    model="gpt-4-vision-preview",
    max_tokens= 200,
    messages=[{"role": "user", "content": ["To są klatki z wideo. Wygeneruj dwa zdania podsumowania.", *images]}    
    ])


print(response.choices[0].message.content)
